// attsharedmemDlg.cpp : implementation file
//

#include "stdafx.h"
#include "attsharedmem.h"
#include "attsharedmemDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif
//

/////////////////////////////////////////////////////////////////////////////
// CAttsharedmemDlg dialog

CAttsharedmemDlg::CAttsharedmemDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CAttsharedmemDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CAttsharedmemDlg)
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CAttsharedmemDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAttsharedmemDlg)
	DDX_Control(pDX, IDC_ST1, m_Static1);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAttsharedmemDlg, CDialog)
	//{{AFX_MSG_MAP(CAttsharedmemDlg)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CAttsharedmemDlg message handlers

BOOL CAttsharedmemDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
	hMapObject = OpenFileMapping(FILE_MAP_ALL_ACCESS,TRUE,"ATITRAY_SMEM");	
	if (hMapObject!=0) {
		data = (PATTData)MapViewOfFile(hMapObject, FILE_MAP_WRITE, 0, 0, 0);
	} else {
		data = NULL;
		m_Static1.SetWindowText("ATI Tray Tools not found");
	}
	// TODO: Add extra initialization here
	SetTimer(1,1000,0);
	return TRUE;  // return TRUE  unless you set the focus to a control
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CAttsharedmemDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CAttsharedmemDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}


void CAttsharedmemDlg::OnTimer(UINT nIDEvent) 
{
	// TODO: Add your message handler code here and/or call default
	CDialog::OnTimer(nIDEvent);
		if (data!=NULL) {
			char s[1000];
			sprintf(s,"GPU Speed - %dMHz\n"\
				"MEM Speed - %dMHz\n"\
				"Current Mode - %s\n"\
				"Temperature Monitor Supported - %s\n"\
				"GPU Temperature - %d\n"\
				"ENV Temperature - %d\n"\
				"Free Video Memory - %d\n"\
				"Free Texture Memory - %d\n"\
				"Memory Used by process - %d\n"\
				"Current API Type - %d\n"
				,
				data->CurGPU, data->CurMEM,
				((data->is3DActive==1) ? "3D" : "2D"),
				((data->isTempMonSupported==1) ? "Yes" : "No"),
				data->GPUTemp,data->ENVTemp,
				data->FreeVideo,
				data->FreeTexture,
				data->MemUsed,
				data->Cur3DApi
			);
			m_Static1.SetWindowText(s);
				
		} else  m_Static1.SetWindowText("Error getting ATI Tray Shared Memory Information");

}

BOOL CAttsharedmemDlg::DestroyWindow() 
{
	// TODO: Add your specialized code here and/or call the base class
	KillTimer(1);
	UnmapViewOfFile(data);
	CloseHandle(hMapObject);
	return CDialog::DestroyWindow();
}
